function [Cc,Dc] = bfor_endogenous_ms_solver_matrices_c(nderivs,ns,that,G)
% 
% Returns the matrices Cc and Dc for solving the first order derivative
%   with respect to chi
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  ns       = number of regimes
%  that     = (ntheta x ns matrix) of theta-hat, the deviation of theta_s 
%               from thetabar
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, G(i,j,s) is the response of y(i) 
%               to state(j) conditional on regime s, state=[xlag;epsilon;chi]
%  
%  OUTPUTS
%   Cc      = {ns x ns) cell of derivative coefficients for solving the
%               system
%   Dc      = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

nx = size(nderivs.dfx{1,1},2);
Cc = cell(ns,ns);
Dc = cell(ns,ns);

for s = 1:ns
    for sp = 1:ns
        dfyp      = nderivs.dfyp{sp,s};
        dfy       = nderivs.dfy{sp,s};
        dfx       = nderivs.dfx{sp,s};
        dftp      = nderivs.dftp{sp,s};
        dft       = nderivs.dft{sp,s};
        
        Cc{sp,s} = [dfx+dfyp*G(:,1:nx,sp) dfy dfyp];
        Dc{sp,s} = dftp*that(:,sp) + dft*that(:,s);
    end
end
